# LOFAR-IT Containers

Containers source by the Italian LOFAR group.

## Prefactor3

This container is based on the "lofaruser/imaging-pipeline:v3.10" base image, and it is available from Docker Hub as "lofarit/prefactor3:pipeline_v3.10".

How to run the container with Docker:

    docker run --rm -v $INPUT_DATA_FOLDER:/input_data,$OUTPUT_DATA_FOLDER:/output_data -it lofarit/prefactor3_base3.10
    
How to run the container wth Singularity:

    singularity run --pid --writable-tmpfs --containall --cleanenv -B$INPUT_DATA_FOLDER:/input_data,$OUTPUT_DATA_FOLDER:/output_data docker://lofarit/prefactor3_base3.10

These commands will start the container and place you in the /home/lofar directlry inside the container. In both cases you have to set the $INPUT_DATA_FOLDER and $OUTPUT_DATA_FOLDER to the input and output data folders respectively, on the host system (i.e. the machine on which you are running the container). Note that the output data folder must exists and have write permissions (if using Singularty, by the user running the container).

How to start prefactor3 once in the container:

    $ genericpipeline.py Pre-Facet-Calibrator.parset -v -d -c pipeline.cfg

..or:

    $ genericpipeline.py Pre-Facet-Target.parset -v -d -c pipeline.cfg

Feel free to have a look and change the files as pipeline.cfg, Pre-Facet-Calibrator.parset and Pre-Facet-Target.parset in the /home/lofar directory inside the container to suit your needs.

Remember that the contents of the container (excluding data on your external volumes as the input/output data directories) will be wiped when you exit the container.