; $Id: starlist.pro, v 2.0 Sep 2024 e.d. $
;
;+
; NAME:
;	STARLIST
;
; PURPOSE:
;	Create a new list of elements representing true or presumed stars.
;
; CATEGORY:
;	STARFINDER auxiliary procedures.
;
; CALLING SEQUENCE:
;	Result = STARLIST(N, X, Y, F, C)
;
; INPUTS:
;	N:	number of elements in the list
;
; OPTIONAL INPUTS:
;	X, Y:	1D vectors with positions of new elements
;	
; F: 1D vector with fluxes of new elements (used only if X, Y are defined)
; 
;	C: 1D vector with correlation coefficients of new elements (used only if X, Y, F are defined)
;
; OUTPUTS:
;	Return initialized list of N elements
;
; MODIFICATION HISTORY:
; 	Written by:	Emiliano Diolaiti, June 2001.
; 	1) Added optional input C in STARLIST (E.D., March 2012).
; 	2) Created this file (E.D., March 2012).
; 	3) Modified data type: from array of structures to structure of arrays (E.D., September 2024).
;-

FUNCTION starlist, n, x, y, f, c

    on_error, 2
    list = { $
            x: fltarr(n), sigma_x: fltarr(n), $   ; x- coordinate and error
            y: fltarr(n), sigma_y: fltarr(n), $   ; y- coordinate and error
            f: fltarr(n), sigma_f: fltarr(n), $   ; flux and error
            c: make_array(n, VALUE = -1.0),   $   ; correlation coefficient
            is_a_star: bytarr(n)}                 ; flag
    if  n_elements(x) ne 0 and n_elements(y) ne 0  then $
       update_list, list, x, y, f, c
    return, list
end
