; $Id: sort_list.pro, v 2.0 Sep 2024 e.d. $
;
;+
; NAME:
;	SORT_LIST
;
; PURPOSE:
;	Sort stars by decreasing flux.
;
; CATEGORY:
;	STARFINDER auxiliary procedures.
;
; CALLING SEQUENCE:
;	Result = SORT_LIST(List, SUBSCRIPTS = S)
;
; INPUTS:
;	List:	list of stars
;
; OPTIONAL OUTPUTS:
;	SUBSCRIPTS: subscripts of sorted stars in the input list.
;
; MODIFICATION HISTORY:
; 	Written by:	Emiliano Diolaiti, June 2001.
;   1) Created this file (E. D., March 2012).
;   2) Modified data type: from array of structures to structure of arrays (E.D., September 2024).
;   3) Corrected comment about keyword parameter SUBSCRIPT 
;      (it is an optional output, not an optional input) (E.D., September 2024).
;-

FUNCTION sort_list, list, SUBSCRIPTS = s

    on_error, 2
    if  n_tags(list) eq 0  then  return, list
    s = reverse(sort(list.f))
    list.x = list.x[s]
    list.sigma_x = list.sigma_x[s]
    list.y = list.y[s]
    list.sigma_y = list.sigma_y[s]
    list.f = list.f[s]
    list.sigma_f = list.sigma_f[s]
    list.c = list.c[s]
    list.is_a_star = list.is_a_star[s]
    return, list
end
