; $Id: reverse_class.pro, v 2.0 Sep 2024 e.d. $
;
;+
; NAME:
;	REVERSE_CLASS
;
; PURPOSE:
;	Reverse classification (star/not star) of an element in a list.
;
; CATEGORY:
;	STARFINDER auxiliary procedures.
;
; CALLING SEQUENCE:
;	Result = REVERSE_CLASS(List, SUBSCRIPTS = S)
;
; INPUTS:
;	List:	list of stars and presumed stars
;
; KEYWORD PARAMETERS:
;	SUBSCRIPTS:	subscripts of elements whose classification
;		must be reversed. If undefined, reverse classification
;		of all elements in the list
;
; OUTPUTS:
;	Return list where the classification of the subscripted elements is reversed
;
; MODIFICATION HISTORY:
; 	Written by:	Emiliano Diolaiti, June 2001.
; 	1) Created this file (E.D., March 2012).
; 	2) Modified data type: from array of structures to structure of arrays (E.D., September 2024).
;-

FUNCTION reverse_class, list, SUBSCRIPTS = s

    on_error, 2
    if  n_elements(s) eq 0  then  s = lindgen(n_elements(list.is_a_star))
    l = list
    l.is_a_star[s] = (not l.is_a_star[s]) and 1B
    return, l
end
