; $Id: merge_list.pro, v 2.0 Sep 2024 e.d. $
;
;+
; NAME:
;	MERGE_LIST
;
; PURPOSE:
;	Merge two lists of stars.
;
; CATEGORY:
;	STARFINDER auxiliary procedures.
;
; CALLING SEQUENCE:
;	Result = MERGE_LIST(L1, L2)
;
; INPUTS:
;	L1, L2:	lists to merge. If L1 is empty, return L2.
;
; OUTPUTS:
;	Return merged list
;
; MODIFICATION HISTORY:
; 	Written by:	Emiliano Diolaiti, June 2001.
; 	1) Created this file (E. D., March 2012).
; 	2) Fixed bug when input list L1 is empty (E. D., April 2012).
; 	3) Modified data type: from array of structures to structure of arrays (E.D., September 2024).
;-

FUNCTION merge_list, l1, l2

    on_error, 2
    if n_tags(l1) eq 0 then $
       l = l2 else $
    begin
       n1 = n_elements(l1.is_a_star)
       n2 = n_elements(l2.is_a_star)
       l = starlist(n1 + n2)
       l.x = [l1.x, l2.x]
       l.sigma_x = [l1.sigma_x, l2.sigma_x]
       l.y = [l1.y, l2.y]
       l.sigma_y = [l1.sigma_y, l2.sigma_y]
       l.f = [l1.f, l2.f]
       l.sigma_f = [l1.sigma_f, l2.sigma_f]
       l.c = [l1.c, l2.c]
       l.is_a_star = [l1.is_a_star, l2.is_a_star]
    endelse
    return, l
end
