; $Id: is_star.pro, v 1.0 Sep 2024 e.d. $
;
;+
; NAME:
;	IS_STAR
;
; PURPOSE:
;	Check status of one or more elements in the list of stars and presumed stars.
;
; CATEGORY:
;	STARFINDER auxiliary procedures.
;
; CALLING SEQUENCE:
;	Result = IS_STAR(List, S)
;
; INPUTS:
;	List:	list of stars and presumed stars
;
;	S:	subscript(s) of element(s) to be checked
;
; OUTPUTS:
;	Return scalar or array of binary values for each element defined by parameter S.
;	Returned value is 1 for a confirmed star, 0 otherwise.
;
; MODIFICATION HISTORY:
; 	Written by:	Emiliano Diolaiti, September 2024.
;-

FUNCTION is_star, list, s

    on_error, 2
    return, list.is_a_star[s] and 1B
end
