; $Id: extract_stars.pro, v 2.0 Sep 2024 e.d. $
;
;+
; NAME:
;	EXTRACT_STARS
;
; PURPOSE:
;	Return sub-list of stars, extracted from a list which might include
;	presumed stars.
;
; CATEGORY:
;	STARFINDER auxiliary procedures.
;
; CALLING SEQUENCE:
;	Result = EXTRACT_STARS(List, N)
;
; INPUTS:
;	List:	star list
;
; OUTPUTS:
;	Return sublist of true stars
;
; OPTIONAL OUTPUTS:
;	N:	number of extracted stars
;
; MODIFICATION HISTORY:
; 	Written by:	Emiliano Diolaiti, June 2001.
;   1) Created this file (E. D., March 2012).
;   2) Modified data type: from array of structures to structure of arrays (E.D., September 2024).
;-

FUNCTION extract_stars, list, n

    on_error, 2
    s = where_stars(list, n)
    if  n ne 0  then begin
      sublist = starlist(n)
      sublist.x = list.x[s]
      sublist.sigma_x = list.sigma_x[s]
      sublist.y = list.y[s]
      sublist.sigma_y = list.sigma_y[s]
      sublist.f = list.f[s]
      sublist.sigma_f = list.sigma_f[s]
      sublist.c = list.c[s]
      sublist.is_a_star = list.is_a_star[s]
    endif else $
      sublist = -1
    return, sublist
end
