; $Id: sort_subap.pro#0.1 $
;
;+
; NAME:
; SORT_SUBAP
;
; PURPOSE:
; Given one of the following kind of inputs
; 1) a set of modes in a 3D cube (2D array in case of 1 mode)
; 2) a wavefront or phase map (2D array)
; 3) the X- and Y- derivatives of a set of modes
; 4) the X- and Y- slopes of a wavefront or phase map
; transform the input(s) in matrix form by sorting the subapertures of the 
; domain over which the inputs are defined.
;
; CATEGORY:
; Modal analysis.
;
; CALLING SEQUENCE:
; Result = SORT_SUBAP(Mask, A)
;
; INPUTS:
; Mask: array with mask defining the domain support (size Npix*Npix).
;
; A: One of the inputs defined in PURPOSE above (size Npix*Npix*NPlane, with NPlane>=1).
; 
; OPTIONAL INPUTS:
; B: Second input of the same type and size as A (applicable for cases 3 and 4 
;    described in PURPOSE).
; 
; OUTPUTS:
; For cases 1) and 2) return a 2D matrix of size (NSubap rows) * (NPlane columns), 
; where NSubap is the number of subapertures in the support domain defined by Mask.
; For cases 3) and 4) return a 2D matrix of size (2*NSubap rows) * (NPlane columns);
; the rows are taken alternatively from inputs A and B.
; The type of the output is the same as the input(s).
;
; MODIFICATION HISTORY:
;   Written by: L. Schreiber (UniBo) 16/09/2010 as MODAL_INT_MATRIX
;   1) E. D. (INAF-OABo), April 2011. Revised and renamed MODAL_MATRIX. 
;      Moved calculation of reconstruction matrix to routine SVD_INV_MATRIX.
;   2) E.D. (INAF-OABo), May 2011. Renamed to SORT_SUBAP and revised to work for 
;      different inputs.
;-

function sort_subap, mask, a, b

on_error, 2

nax = 1
if n_elements(b) ne 0 then nax = 2
if size(a, /N_DIM) eq 2 then $
   nplane = 1 else nplane = (size(a, /DIM))[2]
w = where(mask, npt)
typ = size(a, /TYPE)
if nax eq 2 then typ = max([typ, size(b, /TYPE)])
aa = make_array(npt, nplane, TYPE = typ)
if nax eq 2 then bb = make_array(npt, nplane, TYPE = typ)

c = make_array(nax*npt, nplane, TYPE = typ)

for i = 0L, nplane-1 do begin
   aa[*,i]=(a[*,*,i])[w]
   if nax eq 2 then bb[*,i]=(b[*,*,i])[w]
endfor

for i = 0L, npt-1 do begin
   k = nax*i
   c[k,*] = aa[i,*]
   if nax eq 2 then c[k+1,*] = bb[i,*]
endfor

return, transpose(c)
end
