
FUNCTION radii, nr, np, ri
                                   ; generate an nr x np array with np
                                   ; copies of the radial coordinate
                                   ; array. Radial coordinate span the
                                   ; range from r=ri to r=1 with
                                   ; successive annuli having equal
                                   ; areas.

                                   ; ie, the area between ri and 1 is
                                   ; divided into nr equal rings, and
                                   ; the points are positioned at the
                                   ; half-area mark on each ring; 
                                   ; there are no points on the border.    
    
    r2 = ri^2 + (findgen(nr)+0.5)/nr * (1.0 - ri^2)
    rs = sqrt(r2)
    ra = rebin (rs, nr, np)
    return, ra
END


FUNCTION Polang, r
                                   ; generate an array with the same
                                   ; dimensions as r, but containing
                                   ; the azimuthal values for a polar
                                   ; coordinate system.
    s =  size(r)
    nr = s(1)
    np = s(2)
    phi = fltarr(nr, np)
    phi1 = findgen(np) / float(np) * 2.0 * !Pi
    
    phi = transpose (rebin (phi1, np, nr))
    return, phi
END







PRO setpincs, ax, ay, px, py, ri,  pincx, pincy, pincw
                                   ; determine a set of squares for
                                   ; interpolating from cartesian to
                                   ; polar coordinates, using only
                                   ; those points with ri < r < 1
    s = size (ax)
    nc = s(1)
    s = size(px)
    nr = s(1)
    np = s(2)
    dcar = (ax(nc-1) - ax(0)) / (nc-1)
    ofcar = ax(0,0)

    rlx = (px - ofcar)/dcar
    rly = (py - ofcar)/dcar
    lx = long (rlx)
    ly = long (rly)
    shx = rlx - lx
    shy = rly - ly

    pincx = [[[lx]], [[lx+1]], [[lx+1]], [[lx]]]
    pincy = [[[ly]], [[ly]], [[ly+1]], [[ly+1]]]
    pincw = [[[1-shx]], [[shx]], [[shx]], [[1-shx]]] * $
            [[[1-shy]], [[1-shy]], [[shy]], [[shy]]]
    axy = ax^2 + ay^2
    axyinap = (axy GT ri^2. AND axy LT 1.0)
    pincw = pincw * axyinap(pincx, pincy) 
    pincw = pincw * rebin (1.0/total(pincw, 3), nr, np, 4)
END 




FUNCTION pcgeom, nr, np, ncp, ri, ncmar, ap    

                                   ; px and py are the x and y
                                   ; coordinates of points in the
                                   ; polar arrays.  cr and cp are the r
                                   ; and phi coordinates of points in
                                   ; the cartesian grids.

                                   ; ncmar allows the possibility that
                                   ; there is a margin of ncmar points
                                   ; in the cartesian arays oiutside
                                   ; the region of interest
    nused = ncp - 2*ncmar
    ff = 0.5 * nused
    hw =  float(ncp-1) / 2
    
    r = radii(nr, np, ri) 
    p = polang(r)

    px0 = r * cos(p)
    py0 = r * sin(p)
    px = ff * px0 + hw
    py = ff * py0 + hw
    ax = findgen(ncp, ncp) MOD ncp - 0.5 * (ncp-1)
    ax = ax / (0.5 * nused) 
    ay = transpose(ax)
        
    setpincs, ax, ay, px0, py0, ri,   pincx, pincy, pincw
    dpi = 2 * !Pi
    cr2 = (ax^2 + ay^2) 
    ap = cr2 GT ri^2 AND cr2 LT 1.0
    cr = (cr2 - ri^2) / (1 - ri^2) * nr - 0.5 
    cp = (atan(ay, ax) + dpi) MOD dpi
    cp = (np / dpi) * cp
    
    cr = (cr > 0) < (nr-1)     ; fudge -----, but one of the less bad ones
    cp = (cp > 0) < (np -1)    ; fudge -----  this is the line which
                               ; gives that step in the cartesian grid
                               ; at phi = 0.

    geom = {  $
            px: px,  py: py,  $
            cr: cr,  cp: cp,  $
            pincx: pincx,  pincy: pincy,  pincw: pincw, $
            ap: ap,  $
            ncp: ncp, ncmar: ncmar $
           } 
    return, geom
END


FUNCTION set_pctr, bas, ncp = ncp, ncmar=ncmar
    if n_elements (ncmar) EQ 0 then ncmar = 2
    if n_elements (ncp) EQ 0 then ncp = 128
    
    return, pcgeom (bas.nr, bas.np, ncp, bas.ri, ncmar, ap)
END










