; $Id: pupilmask.pro #1.0 $
;
;+
; NAME:
; PUPILMASK
;
; PURPOSE:
; This function computes a circular pupil mask, defined as follows:
;    1 over pupil domain
;    0 outside pupil domain.
; A central obstruction can be defined.
;
; CATEGORY:
; Array operations.
;
; CALLING SEQUENCE:
; Result = PUPILMASK(Npix, Diameter)
;
; INPUTS:
; Npix: size of square array with pupil mask
; 
; Diameter: diameter of pupil
; 
; KEYWORD PARAMETERS:
; OBSTRUCTION: relative central obstruction of pupil mask.
;
; OUTPUTS:
; The function returns a floating point 2D array with the pupil mask.
;
; OPTIONAL OUTPUTS:
; X, Y: 2D arrays of X- and Y- coordinates used to define pupil mask.
; 
; EXAMPLE:
; IDL> m = pupilmask(16,16)
;
; MODIFICATION HISTORY:
;   Written by: E.D. (INAF-OABo), April 2011.
;-

function pupilmask, npix, diameter, OBSTRUCTION = o, x, y

if n_elements(o) eq 0 then o = 0.0
radius = diameter / 2.0
x = rebin(coordinate(npix), npix, npix)
y = rebin(transpose(coordinate(npix)), npix, npix)
r = sqrt(x^2 + y^2) / radius
z = fltarr(npix,npix)
z[where(r ge o and r le 1.0)] = 1.0

return, z
end
