
FUNCTION gkl_sfi, bas, i
                               ; return the i'th function from the
                               ; generalised KL basis bas. bas must be
                               ; generated first with gkl_basis.
    
    IF n_params() NE 2 THEN BEGIN 
        print, "usage: a = gkl_sfi (basis, i)"
        print, "the basis must be generated with 'gkl_basis' first"
        return, 0
    END
    IF i GT bas.nfunc THEN BEGIN 
        print, "the basis only contains ", nfunc, "functions"
        return, 0
    END
    
    
    nr = bas.nr
    np = bas.np
    ord = bas.ord (i)

    sf =   rebin(bas.rabas(*,i), nr, np) * rebin(bas.azbas(ord, *), nr, np)
    return, sf
END

