; $Id: coordinate.pro v 1.0 $
;
;+
; NAME:
; COORDINATE
;
; PURPOSE:
; This function defines a vector of coordinates symmetric with respect to an origin.
;
; CATEGORY:
; Array operations.
;
; CALLING SEQUENCE:
; Result = FUNCTION_NAME(N)
;
; INPUTS:
; N:  Integer number of elements. If N is not integer, it is truncated to 
;    the lower integer value.
;
; OUTPUTS:
; This function returns a float array of coordinates defined as follows:
; -(N-1)/2, ..., -0.5, +0.5, ..., +(N-1)/2, if N is even
; -N/2, ..., -1.0, 0.0, +1.0, ..., +N/2, if N is odd.
; 
; EXAMPLE:
; IDL> print, coordinate(4)
;     -1.50000    -0.500000     0.500000      1.50000
; IDL> print, coordinate(3)
;     -1.00000     0.000000      1.00000
;
; MODIFICATION HISTORY:
;   Written by: E.D. (INAF-OABo), April 2011
;-

function coordinate, n

k = fix(n)
x = findgen(k) - k/2
if k mod 2 eq 0 then x = x + 0.5

return, x
end