;---------------------------------------------------------------------------------
;
;-Cette procedure reconstruit la WFE sur la pupille principale pas LS Fitting
;
;   Entrees : px          tableau des pentes en X estimates sur la pupille principale
;             py          tableau des pentes en Y estimates sur la pupille principale
;             masque      tableau des masques dans la pupille principale
;             recmat      tableau des recontruction (calcule par recmat.pro)
;             zer         zernike cube matrix
;
;   Sorties : wfe         tableau complexe de la WFE reconstruite sur la pupille principale
;


PRO calc_wfe_ls, px, py, masque, recmat, zer, wfe, c, notilt = notilt

  s = size(px,/dim)
  nzer = (size(recmat,/dim))[1]
  wfe = dblarr(s[0],s[1])
  
  c = transpose(recmat ## sort_subap(masque, px, py))
  
if not keyword_set(notilt) then $
  for i = 0,nzer-1 do wfe = wfe + c[i] * zer[*,*,i] else $
  for i = 2,nzer-1 do wfe = wfe + c[i] * zer[*,*,i]
  

return
end