;+ Author: Laura Schreiber - August 2022
;
;ROUTINE NAME:
;asong_leasy_tilt
;
;PURPOSE:
;Computes the tilt signal x and y from the signal in each pupil using the formula:
;tilt x = ((A+B)-(C+D))/ A+B+C+D;      tilt y = ((A+C)-(B+D))/ A+B+C+D;      
;
;CALLING SEQUENCE:
;asong_leasy_tilt, frame, qmask, tilt
;
;INPUT:
;frame:  2D (3D if SEQ keyword is set) array containing the image of the 4 pupil 
;qmask:  3D array with four planes, each representing a binary mask 
;        associated to one quadrant of the sensor
;        
;KEYWORDS:
;SEQ: in case of sequential pupil images (no MLA to produce 4 pupil images)  
;GAIN : gain to be computed or calibrated extenally        
;
;OUTPUT: 
;tilt :  vector of 2 elements containin the tilt x and y signal 

;-
; NOTE: the tilt is in signal unless the gain is passed to the procedure


PRO asong_leasy_tilt, frame, qmask, $ ; inputs
                      SEQ = SEQ,  GAIN = GAIN,  $ ; keywords
                      tilt            ; output

if keyword_set(SEQ) then begin
  A = total(qmask[*,*,0]*frame[*,*,0])
  B = total(qmask[*,*,1]*frame[*,*,1])
  C = total(qmask[*,*,2]*frame[*,*,2])
  D = total(qmask[*,*,3]*frame[*,*,3])  
endif else begin  
  A = total(qmask[*,*,0]*frame)
  B = total(qmask[*,*,1]*frame)
  C = total(qmask[*,*,2]*frame)
  D = total(qmask[*,*,3]*frame)
endelse



tot = A+B+C+D
;tilt=[((A+B)-(C+D))/tot,((A+C)-(B+D))/tot]
tilt=[((B+D)-(A+C))/tot,((C+D)-(A+B))/tot]
;tilt=[((B+C)-(A+D))/tot,((C+D)-(A+B))/tot]


RETURN
END