;+ Author: Laura Schreiber - August 2022
;
;ROUTINE NAME:
;asong_flat_operation
;
;PURPOSE:
;Devide the image or a cube of images for the flat field. This operation is separated from the background subtraction
;because it requires the mask definition. 
;
;CALLING SEQUENCE:
;asong_flat_operation, image, qmask, flat, image_flat
;
;INPUT:
;image: input 2D/3D array
;flat : 2D array flat field 
;mask : OPTIONAL INPUT 2D array to define the regions in which the image is defined
;
;OUTPUT:
;image_flat :  flatted image or cube

;example
; path = 'folder path here'
; asong_image,path,/bkg,avg_test,/save,name = 'test'




FUNCTION asong_flat_operation, image, flat, mask

image_flat = image * 0.

if n_elements(mask) gt 0 then begin
  w = where(mask)
  if n_elements(size(image,/dim)) eq 3 then begin
    for i = 0,(size(image,/dim))[2] -1 do begin
      f = image[*,*,i] * 0
      im = image[*,*,i]
      f[w] = im[w]/flat[w]
      image_flat[*,*,i] = f
    endfor
  endif else begin
  image_flat[w]=image[w]/flat[w]
  endelse
endif else begin
  image_flat = image / flat
endelse
return, image_flat
END