;+ Author: Laura Schreiber - August 2022
;
; ROUTINE NAME:
; asong_define4quad
;
;PURPOSE:
;For the construction of the qmak.
;
;
;CALLING SEQUENCE:
;asong_define4quad, image
;
;INPUT:
;image: 4 pupils image taken with ASONG
;
;KEYWORDS:
;wscale    = wscale    :  Variable type: Scalar. Graphycal window scaling factor w.r.t. image size. DEFAULT VALUE = 0.5
;silent    = silent    :  set this keyword to not have printed outputs in the IDL console
;log       = log       : set this keyword to visualise the image logarithm and bust the constrast
;
;OUTPUT:
;quad: cube containing the 4 quadrants to select each of the 4 pupils in the correct order
;for the qmask definition.

FUNCTION asong_define4quad, image,             $                                              ;input
                            wscale = wscale  , $
                            silent = silent  , $
                            log = log        , $
                            _EXTRA = extra     ;keyword
                            


quad = fltarr((size(image,/dim))[0],(size(image,/dim))[1],4)

if not keyword_set(wscale)  then wscale  =  0.5
xw_size = wscale * (size(image,/dim))[0]
yw_size = wscale * (size(image,/dim))[1]




window,0, title = 'quad definition',xs = xw_size, ys = yw_size
if not keyword_set(log) then begin
   tvscl, congrid(image,xw_size,yw_size)
endif else begin
   tvscl, congrid(image^0.1,xw_size,yw_size)
endelse
if  not keyword_set(silent)  then begin
  print, 'Select the center of the mask by clicking with the left button of your mouse...'
  print, 'Push right button to exit'
endif

!MOUSE.button = 1 ; &  n_click = 0

;B = ''
;while strupcase(B) ne 'Y' do begin
while  !MOUSE.button eq 1  do begin

;  if  n_click eq 1 then  !MOUSE.button = 4
cursor, x_click, y_click, /NORMAL, /DOWN
  x_click = round(x_click * (size(image,/dim))[0])  &  y_click = round(y_click * (size(image,/dim))[1])

  crosses, tvrd(), x_click/float((size(image,/dim))[0] - 1)*!D.x_size, y_click/float((size(image,/dim))[1] - 1)*!D.y_size, $
    /EXISTING, _EXTRA = extra, /DEVICE, symsize = 200 * wscale, thick = 3
;  read,B,prompt='PRESS Y if THE CROSS IS WELL CENTERED IN THE 4 PUPILS CENTER : '
 ; if  !MOUSE.button eq 1  then  cursor, x_click, y_click, /NORMAL, /DOWN
endwhile
quad[0:x_click,0:y_click,0] = 1
quad[x_click+1:(size(image,/dim))[0]-1,0:y_click,1] = 1
quad[0:x_click,y_click+1:(size(image,/dim))[1]-1,2] = 1
quad[x_click+1:(size(image,/dim))[0]-1,y_click+1:(size(image,/dim))[1]-1,3] = 1

;for i = 0,3 do begin
;  window,i+1, xs = xw_size, ys = yw_size
;  if not keyword_set(log) then begin
;    tvscl, congrid(image * quad[*,*,i],xw_size,yw_size)
;  endif else begin
;    tvscl, congrid(image^0.1 * quad[*,*,i],xw_size,yw_size)
;  endelse  
;endfor
 


return,quad
end