;+ Author: Laura Schreiber - August 2022
;
; ROUTINE NAME:
;asong_check_mask
;
;PURPOSE:
;To verify the mask alignement as size with the 4 measured pupils image.
;Given a mask and an image, it visualize the inverse of the multiplication of the image for the mask and
;for its inverted value.
;
;CALLING SEQUENCE:
;asong_check_mask, image, qmask, xw_size = xw_size, yw_size = yw_size
;
;INPUT:
;image: 4 pupils image taken with ASONG
;qmask: 4 pupils mask to be visualised
;
;KEYWORDS:
;wscale    = wscale    :  Variable type: Scalar. Graphycal window scaling factor w.r.t. image size. DEFAULT VALUE = 0.5    
;;log      = log       : set this keyword to visualise the image logarithm and bust the constrast
;



pro asong_check_mask, image, qmask     , $                         ;input
                      wscale  = wscale , $
                      log     = log    , $
                      _EXTRA  = extra    ;keyword

if not keyword_set(log) then log = 0
if not keyword_set(wscale)  then wscale  =  0.5
xw_size = wscale * (size(image,/dim))[0]
yw_size = wscale * (size(image,/dim))[1]

if log eq 1 then log = 0.1                     


if n_elements(size(qmask,/dim)) eq 3 then $ 
  mask = total(qmask,3)  else $
  mask = qmask

window,1, title = 'mask check direct ', xs = xw_size, ys = yw_size
if not keyword_set(log) then $
   tvscl, congrid(image*mask,xw_size,yw_size) else $
   tvscl, congrid(image^0.1*mask,xw_size,yw_size) 

window,2,title = 'mask check inverse ', xs = xw_size, ys = yw_size
if not keyword_set(log) then $
   tvscl, congrid(image*(1-mask),xw_size,yw_size) else $
   tvscl, congrid(image^log*(1-mask),xw_size,yw_size)

return
end