;ROUTINE NAME:
;asong_center_pupil
;
;PURPOSE:
;Computes the coordinate center of the pupil/pupils
;This procedure should be used if a pinhole mask is applied in the pupil plane
;
;CALLING SEQUENCE:
;centres = asong_center_pupil(ima, npupils, box=box, click=click, x=x, y=y, gauss=gauss)
;
;INPUT:
;ima : frame 
;npupils: number of pupils of wich compute the centres. 
;;        When the pyramid is mounted npupils should be set to 4
;
;KEYWORDS
;box = box:   dimention of the subarray in wich compute the centroid. 
;             When a pupil mask is mounted, this value can be set
;             around 9, otherwise it should be set > then the pupil diameter
;click=click: if this keyword is not set, the subarrays are built 
;             around the default values or around the x and y values
;             when defined. Otherwise an interactive window is opened. 
;             The values around wich the subarray of box=box dimension
;             are cut to compute the centroid are defined by clicking 
;             with the mouse.
;x=x, y=y:    If x and y are defined, the subarray of dimension box=box 
;             is cut Around these values
;gauss=gauss: compute the centroid by means of goussian fit of the 
;             frame in the subarray having dimesion=box
; 
;median_subtract= median_subtract: set this keyword to subtract the 
;                                  median of the image 
 
;
;OUTPUT:
;centres : npupil X 2 array containing the pupil/pupils centres
;




FUNCTION asong_center_pupil, ima, npupils, $
                             median_subtract=median_subtract, box=box, click=click, x=x, y=y, gauss=gauss, threshold = threshold

on_error,2

s=size(ima,/dim)

if keyword_set(median_subtract) then begin
   ima=ima-median(ima)
endif   

  if not keyword_set(box) then box=9
  if keyword_set(click) then begin
      window,xs=s[0],ys=s[1]
      tvscl,congrid(ima,s[0],s[1])
      click_on_max, ima, /mark, nselect=npupils, boxsize=box, x, y
  endif else begin
      if not keyword_set(x) then begin
        x = s[0]/2 
      endif
      if not keyword_set(y) then begin
        y = s[1]/2
      endif  
  endelse       
  centres=fltarr(npupils,2)
  box_cube=fltarr(box,box,npupils)
  for i=0,npupils-1 do begin
     box_cube[*,*,i]=sub_array(ima,box,reference=[x[i],y[i]])
     if keyword_set(gauss) then begin 
        g = gauss2dfit(box_cube[*,*,i],a)
        centres[i,0]=a[4]+x[i]-box/2 &  centres[i,1]=a[5]+y[i]-box/2
     endif else begin
        a = centroid(box_cube[*,*,i])
        centres[i,0]=a[0]+x[i]-box/2 &  centres[i,1]=a[1]+y[i]-box/2
     endelse   
  endfor


return,centres
end