/*
 * File:   proxy.hpp
 * Author: mdm
 *
 * Created on May 2, 2014, 3:18 PM
 */

#ifndef PROXY_HPP
#define	PROXY_HPP

#include <tango.h>

namespace jive_cli
{

class proxy
{
public:
//------------------------------------------------------------------------------
//  Constructor and destructor
//------------------------------------------------------------------------------
    proxy()
    {
        device_proxy_p = new Tango::DeviceProxy("sys/database/2");
    }

    ~proxy()
    {
        if(device_proxy_p)
            delete device_proxy_p;
    }

//------------------------------------------------------------------------------
//  Device properties methods
//------------------------------------------------------------------------------
	void list_servers(bool display_details);

	void list_devices(std::string server_name);

	void rm_server(std::string server_name);

	void rm_device(std::string device_name);

	void save_server(std::string server_name, std::string device_name,
		std::string class_name);

	void save_device(std::string server_name, std::string device_name,
		std::string class_name);

//------------------------------------------------------------------------------
//  Device properties methods
//------------------------------------------------------------------------------
	void list_dev_prop(std::string device_name, bool display_value);

	void get_dev_prop(std::string device_name, std::string property_name);

	void rm_dev_prop(std::string device_name, std::string property_name);

	void save_dev_prop(std::string device_name, std::string property_name,
		std::vector<std::string> property_list);

//------------------------------------------------------------------------------
//  Class properties methods
//------------------------------------------------------------------------------
	void list_class_prop(std::string class_name, bool display_value);

	void get_class_prop(std::string class_name, std::string property_name);

	void rm_class_prop(std::string class_name, std::string property_name);

	void save_class_prop(std::string class_name, std::string property_name,
		std::vector<std::string> property_list);

protected:
//------------------------------------------------------------------------------
//  Server and device methods
//------------------------------------------------------------------------------
	std::vector<std::string> db_get_server_list()
		throw(Tango::DevFailed);

	std::vector<std::string> db_get_device_class_list(std::string server_name)
		throw(Tango::DevFailed);

//------------------------------------------------------------------------------
//  Properties retrieval methods
//------------------------------------------------------------------------------
	std::vector<std::string> db_get_device_property_list(std::string device_name)
		throw(Tango::DevFailed);

	std::vector<std::string> db_get_class_property_list(std::string class_name)
		throw(Tango::DevFailed);

	std::vector<std::string> db_get_device_property(std::string device_name,
		std::string property_name) throw(Tango::DevFailed);

	std::vector<std::string> db_get_class_property(std::string class_name,
		std::string property_name) throw(Tango::DevFailed);

//------------------------------------------------------------------------------
//  Exception handling methods
//------------------------------------------------------------------------------
    void print_exception(Tango::DevFailed& ex)
    {
        std::stringstream error_msg;

        for(unsigned int i = 0; i < ex.errors.length(); ++i)
        {
            error_msg << ex.errors[i].reason.in() << std::endl;
            error_msg << ex.errors[i].desc.in() << std::endl;
            error_msg << ex.errors[i].origin.in() << std::endl;
        }

        std::cerr << "Error: " << error_msg.str() << std::endl;
    }

//------------------------------------------------------------------------------
//  Class variables
//------------------------------------------------------------------------------
    //Tango device proxy pointer
    Tango::DeviceProxy* device_proxy_p;
};

}   //namespace

#endif	/* PROXY_HPP */

