/* 
 * File:   proxy.hpp
 * Author: mdm
 *
 * Created on May 2, 2014, 3:18 PM
 */

#ifndef PROXY_HPP
#define	PROXY_HPP

#include <tango.h>

namespace atk_cli
{

class proxy
{
public:
//------------------------------------------------------------------------------
//  Constructor and destructor
//------------------------------------------------------------------------------
    proxy(std::string device_name)
    {    
        device_proxy_p = new Tango::DeviceProxy(device_name);
    }
    
    ~proxy() 
    { 
        if(device_proxy_p)
            delete device_proxy_p;
    }
    
//------------------------------------------------------------------------------
//  State and status
//------------------------------------------------------------------------------
    void get_state();
    
    void get_status();
    
//------------------------------------------------------------------------------
//  Attributes methods
//------------------------------------------------------------------------------    
    void list_attributes();
    
    void read_attribute(std::string attr_name);

protected:    
//------------------------------------------------------------------------------
//  Utilities methods
//------------------------------------------------------------------------------    
    std::string state_to_string(Tango::DevState state) 
        throw(std::invalid_argument);
    
    std::string attr_to_string(Tango::DeviceAttribute dev_attr) 
        throw(std::invalid_argument);    
    
//------------------------------------------------------------------------------
//  Exception handling methods
//------------------------------------------------------------------------------
    void print_exception(Tango::DevFailed& ex)
    {
        std::stringstream error_msg;

        for(unsigned int i = 0; i < ex.errors.length(); ++i) 
        {    
            error_msg << ex.errors[i].reason.in() << std::endl;
            error_msg << ex.errors[i].desc.in() << std::endl;
            error_msg << ex.errors[i].origin.in() << std::endl;
        }    

        std::cerr << "Error: " << error_msg.str() << std::endl;
    }

//------------------------------------------------------------------------------
//  Class variables
//------------------------------------------------------------------------------
    //Tango device proxy pointer
    Tango::DeviceProxy* device_proxy_p;    
};
    
}   //namespace

#endif	/* PROXY_HPP */

