/* 
 * File:   proxy.hpp
 * Author: mdm
 *
 * Created on May 2, 2014, 3:18 PM
 */

#ifndef PROXY_HPP
#define	PROXY_HPP

#include <tango.h>

namespace astor_cli
{

class proxy
{
public:
//------------------------------------------------------------------------------
//  Constructor and destructor
//------------------------------------------------------------------------------
    proxy()
    {
        databased_name = "sys/database/2";
        starter_name = "tango/admin/";        
        device_proxy_p = 0; 
    }
    
    ~proxy() 
    { 
        if(device_proxy_p)
            delete device_proxy_p;
    }
    
//------------------------------------------------------------------------------
//  Get host list
//------------------------------------------------------------------------------
    void get_host_list();

//------------------------------------------------------------------------------
//  Get host servers info list
//------------------------------------------------------------------------------
    void get_host_servers_info(std::string host_name);
    
//------------------------------------------------------------------------------
//  Get host running and stopped server
//------------------------------------------------------------------------------
    void get_host_running_servers(std::string host_name, bool controlled);

    void get_host_stopped_servers(std::string host_name, bool controlled);
    
//------------------------------------------------------------------------------
//  Start stop and kill server on host
//------------------------------------------------------------------------------
    void start_host_server(std::string host_name, std::string server_name);
    
    void stop_host_server(std::string host_name, std::string server_name);
    
    void kill_host_server(std::string host_name, std::string server_name);
    
//------------------------------------------------------------------------------
//  Get and set server starter info
//------------------------------------------------------------------------------
    void get_server_info(std::string server_name);
    
    void put_server_info(std::string server_name, std::string host_name,
        unsigned int controlled, unsigned int startup);    
    
protected:
//------------------------------------------------------------------------------
//  Exception handling methods
//------------------------------------------------------------------------------
    void print_exception(Tango::DevFailed& ex)
    {
        std::stringstream error_msg;

        for(unsigned int i = 0; i < ex.errors.length(); ++i) 
        {    
            error_msg << ex.errors[i].reason.in() << std::endl;
            error_msg << ex.errors[i].desc.in() << std::endl;
            error_msg << ex.errors[i].origin.in() << std::endl;
        }    

        std::cerr << "Error: " << error_msg.str() << std::endl;
    }

//------------------------------------------------------------------------------
//  Unsigned integer to string conversion method
//------------------------------------------------------------------------------
    std::string int_to_string(unsigned int value)
    {
        std::stringstream conversion;
        conversion << value;
        
        return conversion.str();
    }
    
//------------------------------------------------------------------------------
//  Class variables
//------------------------------------------------------------------------------    
    //Tango database device name 
    std::string databased_name;

    //Tango starter device partial name
    std::string starter_name;
    
    //Tango device proxy pointer
    Tango::DeviceProxy* device_proxy_p;    
};
    
}   //namespace

#endif	/* PROXY_HPP */

