#include <tango.h>
#include <iomanip>
#include <cstring>
#include "proxy.hpp"

//==============================================================================
//Print menu
//==============================================================================
void print_help()
{
    std::cout << "AstorCLI - Tango Astor Command LIne - v0.1" 
        << std::endl << std::endl;
    
    std::cout << "Usage: astorcli {command} [arguments]" 
        << std::endl << std::endl;

    std::cout << "Commands:" << std::endl;
    
    std::cout << " --help -> print this message" << std::endl;    
    
    std::cout << " --hosts -> print hosts list" << std::endl;
    
    std::cout << " --servers {hostname} -> "
        "print servers info for a specified host" << std::endl;

    std::cout << " --running {hostname} {controlled} -> "
        "print running servers for a specified host" << std::endl;    
    
    std::cout << " --stopped {hostname} {controlled} -> "
        "print stopped servers for a specified host" << std::endl;
    
    std::cout << " --start {hostname} {server} -> "
        "start server on a specified host" << std::endl;
    
    std::cout << " --stop {hostname} {server} -> "
        "stop server on a specified host" << std::endl;
    
    std::cout << " --kill {hostname} {server} -> "
        "kill server on a specified host" << std::endl;

    std::cout << " --get_info {server} -> "
        "print server info" << std::endl;
    
    std::cout << " --save_info {server} {hostname} {controlled} {startup} -> "
        "save server info" << std::endl << std::endl;
        
    std::cout << "Arguments:" << std::endl;
    
    std::cout << " server -> server_name/instance " << std::endl;
    
    std::cout << " hostname -> host name where server is registered"
        << std::endl;

    std::cout << " controlled -> server startup is controlled by Starter"
        << std::endl;
    
    std::cout << " startup -> server Starter startup level"
        << std::endl << std::endl;
}

//==============================================================================
//Main code
//==============================================================================
int main(int argc, char* argv[])
{
    if(argc < 2)
    {
        std::cerr << "astorcli: missing command operand" << std::endl 
            << "Try \'astorcli --help\' for more information" << std::endl;
        return 1;
    }

    std::string command = argv[1];

    astor_cli::proxy p;
    
    if(command.compare("--help")==0)
    {
        print_help();
    }
    else if(command.compare("--hosts")==0)
    {
        p.get_host_list();
    }
    else if(command.compare("--servers")==0)
    {
        if(argc < 3)
        {
            std::cerr << "astorcli: missing argument operand" << std::endl
                << "Try \'astorcli --help\' for more information" << std::endl;
            return 1;
        }
        
        std::string host_name = argv[2];
        
        p.get_host_servers_info(host_name);
    }
    else if(command.compare("--running")==0)
    {
        if(argc < 4)
        {
            std::cerr << "astorcli: missing argument operand" << std::endl
                << "Try \'astorcli --help\' for more information" << std::endl;
            return 1;
        }
        
        std::string host_name = argv[2];
        
        if(strcmp(argv[3], "0") != 0 && strcmp(argv[3], "1") != 0)
        {
            std::cerr << "astorcli: wrong argument operand" << std::endl
                << "Try \'astorcli --help\' for more information" << std::endl;
            return 1;        
        }
        
        bool controlled;
        std::istringstream(argv[3]) >> controlled;
        
        p.get_host_running_servers(host_name, !controlled);
    }     
    else if(command.compare("--stopped")==0)
    {
        if(argc < 4)
        {
            std::cerr << "astorcli: missing argument operand" << std::endl
                << "Try \'astorcli --help\' for more information" << std::endl;
            return 1;
        }
        
        std::string host_name = argv[2];
        
        if(strcmp(argv[3], "0") != 0 && strcmp(argv[3], "1") != 0)
        {
            std::cerr << "astorcli: wrong argument operand" << std::endl
                << "Try \'astorcli --help\' for more information" << std::endl;
            return 1;        
        }    

        bool controlled;
        std::istringstream(argv[3]) >> controlled;
        
        p.get_host_stopped_servers(host_name, !controlled);
        
    }
    else if(command.compare("--start")==0)
    {
        if(argc < 4)
        {
            std::cerr << "astorcli: missing argument operand" << std::endl
                << "Try \'astorcli --help\' for more information" << std::endl;
            return 1;
        }
        
        std::string host_name = argv[2];
        
        std::string server_name = argv[3];

        p.start_host_server(host_name, server_name);
    }
    else if(command.compare("--stop")==0)
    {
        if(argc < 4)
        {
            std::cerr << "astorcli: missing argument operand" << std::endl
                << "Try \'astorcli --help\' for more information" << std::endl;
            return 1;
        }
        
        std::string host_name = argv[2];
        
        std::string server_name = argv[3];

        p.stop_host_server(host_name, server_name);        
    }
    else if(command.compare("--kill")==0)
    {
        if(argc < 4)
        {
            std::cerr << "astorcli: missing argument operand" << std::endl
                << "Try \'astorcli --help\' for more information" << std::endl;
            return 1;
        }
        
        std::string host_name = argv[2];
        
        std::string server_name = argv[3];

        p.kill_host_server(host_name, server_name);        
    }    
    else if(command.compare("--get_info")==0)
    {
        if(argc < 3)
        {
            std::cerr << "astorcli: missing argument operand" << std::endl
                << "Try \'astorcli --help\' for more information" << std::endl;
            return 1;
        }
        
        std::string server_name = argv[2];
        
        p.get_server_info(server_name);
    }
    else if(command.compare("--save_info")==0)
    {
        if(argc < 6)
        {
            std::cerr << "astorcli: missing argument operand" << std::endl
                << "Try \'astorcli --help\' for more information" << std::endl;
            return 1;
        }
        
        std::string server_name = argv[2];
        
        std::string host_name = argv[3];
        
        if(strcmp(argv[4], "0") != 0 && strcmp(argv[4], "1") != 0)
        {
            std::cerr << "astorcli: wrong argument operand" << std::endl
                << "Try \'astorcli --help\' for more information" << std::endl;
            return 1;        
        }    
        
        bool controlled;
        std::istringstream(argv[4]) >> controlled;

        if(strcmp(argv[5], "0") != 0 && strcmp(argv[5], "1") != 0 &&
            strcmp(argv[5], "2") != 0 && strcmp(argv[5], "3") != 0 &&
            strcmp(argv[5], "4") != 0 && strcmp(argv[5], "5") != 0)
        {
            std::cerr << "astorcli: wrong argument operand" << std::endl
                << "Try \'astorcli --help\' for more information" << std::endl;
            return 1;        
        }

        int startup;
        std::istringstream(argv[5]) >> startup;
        
        p.put_server_info(server_name, host_name, controlled, startup);
    }    
    else
    {
        std::cerr << "astorcli: wrong command operand" << std::endl 
            << "Try \'astorcli --help\' for more information" << std::endl;
        return 1;        
    }
    
    return 0;
}
