#include <tango.h>
#include <iomanip>
#include <cstring>
#include "proxy.hpp"

//==============================================================================
//Print menu
//==============================================================================
void print_help()
{
    std::cout << "ATKCLI - Tango ATK Command LIne - v0.1" 
        << std::endl << std::endl;
    
    std::cout << "Usage: atkcli {command} [arguments]" 
        << std::endl << std::endl;

    std::cout << "Commands:" << std::endl;
    
    std::cout << " --help -> print this message" << std::endl;    
        
    std::cout << " --state {devicename} -> print device state" << std::endl;

    std::cout << " --status {devicename} -> print device status" << std::endl;
    
    std::cout << " --list_attr {devicename} -> "
        "print device attributes list" << std::endl;

    std::cout << " --read_attr {devicename} {attribute} -> "
        "print attribute value" << std::endl;    
    
    std::cout << "Arguments:" << std::endl;
    
    std::cout << " device -> tango device name xxx/yyy/zzz "
        << std::endl;
    
    std::cout << " attribute -> tango device attribute "
        << std::endl << std::endl;
}

//==============================================================================
//Main code
//==============================================================================
int main(int argc, char* argv[])
{
    if(argc < 2)
    {
        std::cerr << "atkcli: missing command operand" << std::endl 
            << "Try \'atkcli --help\' for more information" << std::endl;
        return 1;
    }

    std::string command = argv[1];

    if(command.compare("--help")==0)
    {
        print_help();
    }
    else if(command.compare("--state")==0)
    {
        if(argc < 3)
        {
            std::cerr << "atkcli: missing argument operand" << std::endl
                << "Try \'atkcli --help\' for more information" << std::endl;
            return 1;
        }
        
        std::string device_name = argv[2];
        
        atk_cli::proxy p(device_name);
        p.get_state();
    }
    else if(command.compare("--status")==0)
    {
        if(argc < 3)
        {
            std::cerr << "atkcli: missing argument operand" << std::endl
                << "Try \'atkcli --help\' for more information" << std::endl;
            return 1;
        }
        
        std::string device_name = argv[2];
        
        atk_cli::proxy p(device_name);
        p.get_status();
    }    
    else if(command.compare("--list_attr")==0)
    {
        if(argc < 3)
        {
            std::cerr << "atkcli: missing argument operand" << std::endl
                << "Try \'atkcli --help\' for more information" << std::endl;
            return 1;
        }
        
        std::string device_name = argv[2];
        
        atk_cli::proxy p(device_name);
        p.list_attributes();
    }
    else if(command.compare("--read_attr")==0)
    {
        if(argc < 4)
        {
            std::cerr << "atkcli: missing argument operand" << std::endl
                << "Try \'atkcli --help\' for more information" << std::endl;
            return 1;
        }
        
        std::string device_name = argv[2];
        
        std::string attribute = argv[3];
        
        atk_cli::proxy p(device_name);
        p.read_attribute(attribute);
    }    
    else
    {
        std::cerr << "atkcli: wrong command operand" << std::endl 
            << "Try \'atkcli --help\' for more information" << std::endl;
        return 1;        
    }
    
    return 0;
}
