/**
 * JS code included only in index.php page.
 */
// IIFE for keeping private functions and variables inside.
(function ($) {

    /**
     * Function factory used to generate function to be executed at timeout (see below)
     * @param {string} searchText
     * @returns {Function}
     */
    function searchUserFactory(searchText) {
        return function () {
            $.get('user?search=' + searchText, function (response) {
                var users = JSON.parse(response);

                // Display the selector only if we have some results
                $('#user-selector-group').toggleClass('hide', users.length === 0);

                // Fill the user selector
                $userSelector = $('#user-selector-group select');
                $userSelector.empty();
                for (var i = 0; i < users.length; i++) {
                    $userSelector.append('<option value="' + i + '">' + users[i] + '</option>');
                }
            });
        };
    }

    /**
     * Function associated to the "Send join request" button on the join modal
     * dialog.
     */
    function sendJoinRequest() {

        $userSelector = $('#user-selector-group select');
        var selectedUserIndex = $userSelector.val();

        if (selectedUserIndex !== null) {
            $.post('join', {selectedUserIndex: selectedUserIndex}, function (response) {
                $('#search-user-modal').modal('hide');
                $infoAlert = $('#info-message-alert');
                $infoAlert.find('.info-message').text("An e-mail has been sent to " + response + " primary e-mail address.");
                $infoAlert.removeClass('hide');
            });
        }
    }

    /**
     * Select the primary identity from the available identities of the user.
     * @param {int} index
     */
    window.setPrimaryIdentity = function (index) {
        $.post('primary-identity', {
            index: index
        }, function (response) {
            $('#panel-identities .panel-body').html(response);
            // restore tooltips (JS event handlers are deleted when DOM element
            // is replaced).
            loadTooltips();
        });
    };

    /**
     * Initialize Bootstrap tooltips.
     * As specified into Bootstrap documentation "For performance reasons, the
     * Tooltip and Popover data-apis are opt-in, meaning you must initialize
     * them yourself."
     */
    function loadTooltips() {
        $('.primary-identity-icon').tooltip();
    }

    // When the document is loaded
    $(document).ready(function () {

        // Add keyup event handler on user search input text
        var timeoutId = 0;
        $(document).on('keyup', '#user-search-text', function (event) {
            clearTimeout(timeoutId);
            var searchUser = searchUserFactory($(event.target).val());
            // wait 500 ms without typing before doing the AJAX call
            timeoutId = setTimeout(searchUser, 500);
        });

        // Add click event handler to join request button
        $(document).on('click', '#send-join-request-btn', sendJoinRequest);

        // Add event handler for closing the info alert message.
        // This is used instead of data-dismiss="alert" in order to maintain
        // the alert inside the DOM and be able to show it again if necessary.
        $(document).on('click', '#info-message-alert .close', function () {
            $('#info-message-alert').addClass('hide');
        });

        loadTooltips();
    });

})(jQuery);