<?php

/* ----------------------------------------------------------------------------
 *               INAF - National Institute for Astrophysics
 *               IRA  - Radioastronomical Institute - Bologna
 *               OATS - Astronomical Observatory - Trieste
 * ----------------------------------------------------------------------------
 *
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

$CONTEXT_ROOT = "/rap-ia2";
$VERSION = "1.0.2";

$PROTOCOL = stripos($_SERVER['SERVER_PROTOCOL'], 'https') ? 'https://' : 'http://';
$BASE_PATH = $PROTOCOL . $_SERVER['HTTP_HOST'] . $CONTEXT_ROOT;

$LOG_PATH = ROOT . "/logs/rap-service.log";
$AUDIT_LOG_PATH = ROOT . "/logs/rap-audit.log";
$LOG_LEVEL = Monolog\Logger::DEBUG;

$CALLBACKS = [
    array(
        'url' => 'http://localhost:8087/grouper',
        'title' => 'Login to Grouper',
        'logo' => 'grouper.png'
    ),
    array(
        'url' => 'http://localhost/rap-ia2/',
        'title' => 'Account Management',
        'logo' => 'account-manager.png'
    )
];

$DATABASE = array(
    'dbtype' => 'MySQL',
    'hostname' => 'localhost',
    'port' => 3306,
    'username' => 'XXXXXX',
    'password' => 'XXXXXX',
    'dbname' => 'rap'
);

$AUTHENTICATION_METHODS = array(
    'eduGAIN' => array(),
    'Google' => array(
        'id' => "XXXXXX",
        'secret' => "XXXXXX",
        'callback' => $BASE_PATH . "/auth/oauth2/google_token.php"),
    'Facebook' => array(
        'id' => "XXXXXX",
        'secret' => "XXXXXX",
        'version' => "v2.2",
        'callback' => $BASE_PATH . "/auth/oauth2/facebook_token.php"),
    'LinkedIn' => array(
        'id' => 'XXXXXX',
        'secret' => 'XXXXXX',
        'callback' => $BASE_PATH . '/auth/oauth2/linkedin_token.php'
    ),
    'X.509' => array(),
    'DirectIdP' => array(
        'url' => 'https://sso.ia2.inaf.it/Shibboleth.sso/Login?entityID=https://sso.ia2.inaf.it/idp/shibboleth&target=https://sso.ia2.inaf.it/rap-ia2/auth/saml2/aai.php',
        'logo' => 'img/ia2-logo-60x60.png',
        'logo_alt' => 'IA2 logo',
        'description' => 'Use the IA2 Logo to Login if you have an account provided by IA2 or self registered'
    )
);

$GROUPER = array(
    'wsURL' => 'http://hostname/grouper-ws/',
    'user' => 'XXXXXX',
    'password' => 'XXXXXX'
);
