<?php

/* ----------------------------------------------------------------------------
 *               INAF - National Institute for Astrophysics
 *               IRA  - Radioastronomical Institute - Bologna
 *               OATS - Astronomical Observatory - Trieste
 * ----------------------------------------------------------------------------
 *
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/* This page MUST be protected by Shibboleth authentication 
 * On Apache httpd:
 * AuthType shibboleth
 * ShibRequestSetting requireSession 1
 * Require valid-user
 */

include '../../include/init.php';
startSession();

if (isset($_SERVER['Shib-Session-ID'])) {

    // Retrieving eduPersonPrincipalName (eppn)
    $eppn = $_SERVER['eppn'];

    // Search if the user is already registered into RAP using the eppn.
    // The persistent id should be a more appropriate identifier, however at IA2
    // we need to import all INAF user into RAP, even if they will never register,
    // and in that case we know only their eppn.
    $user = $userHandler->findUserByIdentity(RAP\Identity::EDU_GAIN, $eppn);

    if ($user === null) {
        // Creating a new user
        $user = new RAP\User();

        $identity = new RAP\Identity(RAP\Identity::EDU_GAIN);
        $identity->email = $_SERVER['mail'];
        $identity->name = $_SERVER['givenName'];
        $identity->surname = $_SERVER['sn'];
        $identity->typedId = $eppn;
        $identity->eppn = $eppn;
        //$_SERVER['Shib-Identity-Provider']

        $user->addIdentity($identity);

        $userHandler->saveUser($user);
    }

    $auditLog->info("LOGIN,eduGAIN," . $user->id);
    $callbackHandler->manageLoginRedirect($user, $session);
} else {
    http_response_code(500);
    die("Shib-Session-ID not found!");
}
