<?php

/* ----------------------------------------------------------------------------
 *               INAF - National Institute for Astrophysics
 *               IRA  - Radioastronomical Institute - Bologna
 *               OATS - Astronomical Observatory - Trieste
 * ----------------------------------------------------------------------------
 *
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/* Google redirect and callback page */

include '../../include/init.php';
startSession();

// Retrieve Google configuration
$Google = $AUTHENTICATION_METHODS['Google'];

$client = new Google_Client(array(
    'client_id' => $Google['id'],
    'client_secret' => $Google['secret'],
    'redirect_uri' => $Google['callback'],
        ));

// Ask permission to obtain user email and profile information
$client->setScopes(array(Google_Service_People::USERINFO_EMAIL, Google_Service_People::USERINFO_PROFILE));

if (isset($_REQUEST['logout'])) {
// Reset the access token stored into the session
    unset($_SESSION['access_token']);
}

if (isset($_GET['code'])) {
// An access token has been returned from the auth URL.
    $client->authenticate($_GET['code']);
    $_SESSION['access_token'] = $client->getAccessToken();
}

//if (isset($_SESSION['access_token'])) {
//    $client->setAccessToken($_SESSION['access_token']);
//}

if ($client->getAccessToken()) {

    // Query web service for retrieving user information
    $service = new Google_Service_People($client);

    try {
        $res = $service->people->get('people/me', array('requestMask.includeField' => 'person.names,person.email_addresses'));
    } catch (Google_Service_Exception $e) {
        echo '<p>' . json_encode($e->getErrors()) . '</p>';
        $thisPage = $PROTOCOL . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'];
        echo '<p><a href="' . $thisPage . '?logout">Click here to unset the access token</a></p>';
    }

    $name = $res->getNames()[0]->getGivenName();
    $surname = $res->getNames()[0]->getFamilyName();

    $emailAddresses = [];
    foreach ($res->getEmailAddresses() as $addr) {
        array_push($emailAddresses, $addr->value);
    }

    $typedId = explode('/', $res->getResourceName())[1];

    // Search if the user is already registered into RAP using the Google ID.
    $user = $userHandler->findUserByIdentity(RAP\Identity::GOOGLE, $typedId);

    if ($user === null) {
        // Create new user
        $user = new RAP\User();

        $identity = new RAP\Identity(RAP\Identity::GOOGLE);
        $identity->email = $emailAddresses[0];
        $identity->name = $name;
        $identity->surname = $surname;
        $identity->typedId = $typedId;

        $user->addIdentity($identity);

        $userHandler->saveUser($user);
    }

    $auditLog->info("LOGIN,Google," . $user->id);
    $callbackHandler->manageLoginRedirect($user, $session);

    die();
} else {
    // Redirect to Google authorization URL for obtaining an access token
    $authUrl = $client->createAuthUrl();
    header('Location: ' . $authUrl);
    die();
}
?>
