<?php

/* ----------------------------------------------------------------------------
 *               INAF - National Institute for Astrophysics
 *               IRA  - Radioastronomical Institute - Bologna
 *               OATS - Astronomical Observatory - Trieste
 * ----------------------------------------------------------------------------
 *
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/* This page uses the Facebook API for generating the redirect URL to use for Facebook login */

include '../../include/init.php';
startSession();

// Retrieve Facebook configuration
$Facebook = $AUTHENTICATION_METHODS['Facebook'];

$fb = new Facebook\Facebook([
    'app_id' => $Facebook['id'],
    'app_secret' => $Facebook['secret'],
    'default_graph_version' => $Facebook['version'],
        ]);

$helper = $fb->getRedirectLoginHelper();

$permissions = ['email']; // Optional permissions: we need user email

$loginUrl = $helper->getLoginUrl($Facebook['callback'], $permissions);

header("Location: $loginUrl");
?>
