<?php

/*
 * This file is part of rap
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

/**
 * REST backend for JavaScript code (AJAX calls).
 */
//

function checkSession() {

    session_start();

    global $locator;
    if ($locator->getSession()->getUser() === null) {
        http_response_code(401);
        die("You must be registered to perform this action");
    }
}

/**
 * Set the primary identity based on the index of the identity clicked by the
 * user on the Account Management page. We MUST use the index and not directly
 * the identity id for security reason (one can use the browser developer tools
 * for calling the AJAX call with an arbitrary number).
 */
Flight::route('POST /primary-identity', function() {

    checkSession();
    global $locator;

    $session = $locator->getSession();

    $identityIndex = intval(Flight::request()->data['index']);
    $identityId = $session->getUser()->identities[$identityIndex]->id;

    $locator->getUserDAO()->setPrimaryIdentity($session->getUser()->id, $identityId);
    $session->updatePrimaryIdentity($identityId);

    // Following variable is used to render user-data
    $user = $session->getUser();
    include 'user-data.php';
});
