# Remote Authentication Portal

An authentication portal supporting eduGAIN (using Shibboleth SP), social logins (Google, LinkedIn and Facebook) and X.509 certificates. Caller services always see an OIDC flow. Account linking and merging is supported. Currently used for authenticating on [IA2 services](https://sso.ia2.inaf.it).

## Docker demo

A working demo using Docker Compose is available on docker folder. It includes also [IA2 Group Membership Service](https://www.ict.inaf.it/gitlab/ia2/ia2-gms) (groups management). The demo is configured only with the fake login mode (for functional testing purposes), but you can configure any social login (see config-example.yaml). eduGAIN and X.509 can't work inside this setup since proper TLS certificates and Shibboleth SP need to be installed.

To start the demo:

    docker-compose pull
    docker-compose build
    docker-compose up -d

RAP is available on http://localhost:8080/rap-ia2

After you performed a first login you can set your user as superadmin on GMS by running the following command:

    docker exec -it <gms-db-container-id> bash -c "echo \"INSERT INTO gms_permission (group_id, user_id, permission, group_path) VALUES('ROOT', '1', 'ADMIN', '')\" | psql -U postgres"

Then you can create groups and memberships using the GMS UI (http://localhost:8081/gms).

Cleanup:

    docker-compose down
    docker volume prune

## Manual Installation

Requirements:

* Apache httpd server
* PHP (and composer for retrieving dependecies)
* MySQL/MariaDB

See the complete list of packages inside [base Dockerfile](docker/base-Dockerfile).

Put RAP sources in `/var/www/html/rap-ia2` and install PHP dependencies with `composer install`.

Install also the bcmath PHP package (used in X.509 parser).

### MySQL / MariaDB

Create a dedicated database and user:

    CREATE DATABASE rap;
    CREATE USER rap@localhost IDENTIFIED BY 'XXXXXX';
    GRANT ALL PRIVILEGES ON rap.* TO rap@localhost;

Then run the setup script:

    mysql -u root -p <  sql/setup-database.sql

### Apache (httpd)

See the [configuration file](docker/rap.conf) used in Docker image.

### Social networks

Before using social API it is necessary to register an application on each social network and obtain API keys and secrets:

* https://console.developers.google.com
* https://www.linkedin.com/developer/apps
* https://developers.facebook.com/apps

### Configuration file

Copy the `config-example.yaml` into `config.yaml` and edit it for matching your needs.

### Generate keypair

    php exec/generate-keypair.php

A cron job for key rotation has to be set up.

### Logs directory

Create the logs directory and assign ownership to the Apache user (usually www-data or apache)

    mkdir logs
    sudo chown www-data logs

### Run Unit Tests and build code coverage report

(XDebug or another code coverage driver needs to be installed; e.g. `sudo apt install php-xdebug`)

    ./vendor/bin/phpunit --bootstrap vendor/autoload.php --coverage-html build/coverage-report tests/

DAO tests are disabled by default, unless the environment variable `TEST_DAO` has been set to `true`. DAO tests require a test database up and running (it can be started using the related Docker image).

## Additional information and developer guide

See the wiki: https://www.ict.inaf.it/gitlab/ia2/rap-ia2/wikis/home

## Troubleshooting

### Class not found while developing

If you see a message like this:

    PHP Fatal error:  Uncaught Error: Class 'RAP\\[...]' not found

probably you have to regenerate the PHP autoload calling `composer dumpautoload` in RAP root directory.
