/**
 * JavaScript necessary for the page views/x509-name-surname.php
 */
(function ($) {

    var _fullName;
    /**
     * @param {string} fullName: name+surname
     */
    window.initPage = function (fullName) {
        _fullName = fullName;
    };

    /**
     * Calculate the surname removing the selected candidate name from the full
     * name.
     */
    function fillSurnameFromSelectedCandidateName() {
        var selectedName = $('#name-selector option:selected').text().trim();
        var surname = _fullName.substring(selectedName.length + 1);
        $('#surname-text').text(surname);
    }

    // When the document is loaded
    $(document).ready(function () {
        // Add event handler on the name-selector dropdown menu
        $(document).on('change', '#name-selector', fillSurnameFromSelectedCandidateName);
        fillSurnameFromSelectedCandidateName();
    });

})(jQuery);
