(function () {

    function getUserPanel(user) {
        $panelBody = $('<div class="panel-body"></div>');
        for (var i = 0; i < user.identities.length; i++) {
            identity = user.identities[i];
            $identityEl = $('<dl class="dl-horizontal"><dt>');
            $identityEl.append('<dt>Type</dt>');
            $identityEl.append('<dd>' + identity.type + '</dd>');
            $identityEl.append('<dt>Email</dt>');
            $identityEl.append('<dd>' + identity.email + '</dd>');
            if (identity.name) {
                $identityEl.append('<dt>Name</dt>');
                $identityEl.append('<dd>' + identity.name + '</dd>');
            }
            if (identity.surname) {
                $identityEl.append('<dt>Surname</dt>');
                $identityEl.append('<dd>' + identity.surname + '</dd>');
            }
            $panelBody.append($identityEl);
        }
        $panel = $('<div class="panel panel-default"></div>');
        $panel.append($panelBody);
        return $panel;
    }

    function getUser(usersList, id) {
        for (var i = 0; i < usersList.length; i++) {
            var user = usersList[i];
            if (user.id === id) {
                return user;
            }
        }
        return null;
    }

    function createSelectUserFunction(usersList, $container) {
        return function (event) {
            $container.empty();
            var user = getUser(usersList, $(event.target).val());
            if (user) {
                $container.append(getUserPanel(user));
            }
        };
    }

    function createSearchFunctionTimeout(input, select, usersList) {
        var text = $(input).val();
        return function () {
            $.ajax({
                url: 'admin-search?query=' + text,
                type: "GET",
                dataType: 'json',
                xhrFields: {
                    withCredentials: true
                },
                success: function (users) {
                    // empty usersList:
                    usersList.splice(0, usersList.length);
                    var selectEl = $(select);
                    selectEl.empty();
                    for (var i = 0; i < users.length; i++) {
                        var user = users[i];
                        usersList.push(user);
                        var label = null;
                        var types = [];
                        var primaryIdentity = null;
                        for (var j = 0; j < user.identities.length; j++) {
                            var identity = user.identities[j];
                            if (identity.name !== null && identity.surname !== null) {
                                label = identity.name + " " + identity.surname;
                            }
                            if (identity.primary) {
                                primaryIdentity = identity;
                            }
                            types.push(identity.type);
                        }
                        if (label === null) {
                            label = primaryIdentity.email;
                        }
                        label += " (" + types.join(", ") + ") [" + user.id + "]";
                        selectEl.append('<option value="' + user.id + '">' + label + "</option>");
                    }
                    selectEl.attr("disabled", users.length === 0);
                    $('#join-btn-admin').attr("disabled", users1.length === 0 || users2.length === 0);
                    selectEl.trigger('change');
                }
            });
        };
    }

    function createSearchFunction(timer, input, select, usersList) {
        return function () {
            clearTimeout(timer);
            timer = setTimeout(createSearchFunctionTimeout(input, select, usersList), 500);
        };
    }

    var timer1, timer2;

    var input1 = $('#user1_search');
    var input2 = $('#user2_search');
    var select1 = $('#user1_select');
    var select2 = $('#user2_select');

    var users1 = [], users2 = [];

    var search1 = createSearchFunction(timer1, input1, select1, users1);
    var search2 = createSearchFunction(timer2, input2, select2, users2);

    input1.on('keydown', search1);
    input1.on('input', search1);
    input2.on('keydown', search2);
    input2.on('input', search2);

    select1.on('change', createSelectUserFunction(users1, $('#user1_content')));
    select2.on('change', createSelectUserFunction(users2, $('#user2_content')));
})();