<?php

/*
 * This file is part of rap
 * Copyright (C) 2019 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

namespace RAP;

/**
 * Data model for storing information about a RAP client connecting using OAuth2.
 */
class BrowserBasedOAuth2Client extends BrowserBasedClient {

    public $client;
    public $secretHash;
    private $redirectUrls;
    public $scope;
    public $homePage;
    public $showInHome;
    public $scopeAudienceMap = [];

    public function __construct(object $config) {
        $this->client = $config->id;
        $this->secretHash = $config->secret;
        $this->title = isset($config->label) ? $config->label : null;
        $this->icon = isset($config->icon) ? $config->icon : null;
        $this->redirectUrls = isset($config->redirect) ? (is_array($config->redirect) ? $config->redirect : [$config->redirect]) : null;
        $this->scope = $config->scope;
        $this->homePage = isset($config->home) ? $config->home : null;
        $this->showInHome = isset($config->showInHome) ? $config->showInHome : false;
        $this->authMethods = $config->methods;
        $this->scopeAudienceMap = isset($config->scopeAudienceMap) ? $config->scopeAudienceMap : null;
    }

    public function getIconBasePath() {
        return 'client-icons/';
    }

    public function validRedirectUrl(string $redirectUrl): bool {
        if ($this->redirectUrls === null) {
            return false;
        }
        foreach ($this->redirectUrls as $url) {
            if ($redirectUrl === $url) {
                return true;
            }
        }
        return false;
    }

}
