<?php
include 'include/header.php';
?>

<div class="row">
    <div class="col-sm-6 col-sm-offset-3">
        <p>This panel can be used to generate tokens to be used from command line interfaces and desktop applications.</p>
        <br/>
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">Token issuer</h3>
            </div>
            <div class="panel-body">
                <form class="form-horizontal" action="<?php echo $contextRoot . '/token-issuer'; ?>" method="post">
                    <div class="form-group">
                        <label for="service" class="col-sm-4 control-label">Service</label>
                        <div class="col-sm-8">
                            <select class="form-control" id="service" name="audit">
                                <?php
                                foreach ($config->services as $service) {
                                    echo "<option value=\"$service->id\">$service->label</option>";
                                }
                                ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="lifespan" class="col-sm-4 control-label">Duration (hours)</label>
                        <div class="col-sm-8">
                            <select class="form-control" id="lifespan" name="lifespan">
                                <?php
                                foreach ($config->lifespans as $lifespan) {
                                    echo "<option>$lifespan</option>";
                                }
                                ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-sm-8 col-sm-offset-4">
                            <input type="submit" class="btn btn-primary" value="Download token" />
                        </div>
                    </div>
                    <input type="hidden" value="<?php echo $csrfToken; ?>" name="csrf_token" />
                </form>
            </div>
        </div>
        <br/>
        <p class="text-center">
            <strong>
                <a href="<?php echo $contextRoot . '/account'; ?>">Back to account manager</a>
            </strong>
        </p>
    </div>
</div>

<?php
include 'include/footer.php';
