<?php

/*
 * This file is part of rap
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

use PHPUnit\Framework\TestCase;

final class TokenExchangerTest extends TestCase {

    public function testExchange() {
        
        $clientAuthCheckerStub = $this->createMock(\RAP\ClientAuthChecker::class);
        
        $tokenCheckerStub = $this->createMock(\RAP\TokenChecker::class);
        $tokenCheckerStub->method('getValidTokenObject')->willReturn((object) [
            "sub" => "user_id"
        ]);
        
        $tokenBuilderStub = $this->createMock(\RAP\TokenBuilder::class);
        $tokenBuilderStub->method('generateToken')->willReturn("new_token");
        
        $locatorStub = $this->createMock(\RAP\Locator::class);
        $locatorStub->method('getClientAuthChecker')->willReturn($clientAuthCheckerStub);
        $locatorStub->method('getTokenChecker')->willReturn($tokenCheckerStub);
        $locatorStub->method('getTokenBuilder')->willReturn($tokenBuilderStub);
                
        $tokenExchanger = new \RAP\TokenExchanger($locatorStub);
        
        $params = [
            "subject_token" => "subject_token",
            "subject_token_type" => "Bearer",
            "resource" => "resource",
            "audience" => "audience",
            "scope" => "scope",
            "expires_in" => 1800
        ];
        
        $result = $tokenExchanger->exchangeToken($params, []);
        
        $this->assertEquals("new_token", $result['access_token']);
    }

}
