<?php

/*
 * This file is part of rap
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

abstract class BaseDAOTest extends \PHPUnit\Framework\TestCase {

    protected function getFakeLocator(): \RAP\Locator {

        if (getenv('TEST_DAO') !== 'true') {
            $this->markTestSkipped('Test database is needed for testing DAO classes');
        }
        
        $config = (object) [
                    "databaseConfig" => (object) [
                        "dbtype" => 'MySQL',
                        "hostname" => "127.0.0.1",
                        "port" => 3307,
                        "username" => "root",
                        "password" => "",
                        "dbname" => "rap"
                    ]
        ];

        $locatorStub = $this->createMock(\RAP\Locator::class);
        $locatorStub->config = $config;

        return $locatorStub;
    }

}
