<?php

/*
 * This file is part of rap
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

namespace RAP;

class TestLogin extends LoginHandler {

    private $fakeIdentities = [];

    public function __construct(Locator $locator) {
        parent::__construct($locator);

        // Create fake identities
        $this->fakeIdentities[1] = $this->getFakeIdentity(Identity::EDU_GAIN, 1);
        $this->fakeIdentities[2] = $this->getFakeIdentity(Identity::GOOGLE, 2);
        $this->fakeIdentities[3] = $this->getFakeIdentity(Identity::LINKEDIN, 3);
    }

    public function login(): string {
        return $this->locator->getBasePath() . '/auth/test/select';
    }

    public function retrieveToken(int $id): string {
        return $this->onIdentityDataReceived($this->fakeIdentities[$id]);
    }

    private function getFakeIdentity(string $type, int $i): Identity {
        $identity = new Identity($type);
        $identity->email = 'fake-user' . $i . "@example.com";
        $identity->eppn = $identity->email;
        $identity->typedId = 'fake-user' . $i;
        return $identity;
    }

}
