<?php

namespace RAP;

class LinkedInLogin extends LoginHandler {

    public function __construct(Locator $locator) {
        parent::__construct($locator);
    }

    public function login(): string {
        // Retrieve LinkedIn configuration
        $LinkedIn = $this->locator->config->authenticationMethods->LinkedIn;

        $url = "https://www.linkedin.com/oauth/v2/authorization?response_type=code";
        $url .= "&client_id=" . $LinkedIn->id;
        $url .= "&redirect_uri=" . $this->locator->getBasePath() . $LinkedIn->callback;
        $url .= "&state=" . bin2hex(random_bytes(5));
        $url .= "&scope=r_liteprofile%20r_emailaddress%20w_member_social";

        return $url;
    }

    public function retrieveToken(): string {
        // Retrieve LinkedIn configuration
        $LinkedIn = $this->locator->config->authenticationMethods->LinkedIn;

        if (!isset($_REQUEST['code'])) {
            die("Unable to get LinkedIn client code");
        }

        //create array of data to be posted to get AccessToken
        $post_data = array(
            'grant_type' => "authorization_code",
            'code' => $_REQUEST['code'],
            'redirect_uri' => $this->locator->getBasePath() . $LinkedIn->callback,
            'client_id' => $LinkedIn->id,
            'client_secret' => $LinkedIn->secret
        );

        //traverse array and prepare data for posting (key1=value1)
        foreach ($post_data as $key => $value) {
            $post_items[] = $key . '=' . $value;
        }

        //create the final string to be posted
        $post_string = implode('&', $post_items);

        //create cURL connection
        $conn1 = curl_init('https://www.linkedin.com/oauth/v2/accessToken');

        //set options
        curl_setopt($conn1, CURLOPT_CONNECTTIMEOUT, 30);
        curl_setopt($conn1, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($conn1, CURLOPT_SSL_VERIFYPEER, true);
        curl_setopt($conn1, CURLOPT_FOLLOWLOCATION, 1);

        //set data to be posted
        curl_setopt($conn1, CURLOPT_POSTFIELDS, $post_string);

        //perform our request
        $result1 = curl_exec($conn1);
        $info1 = curl_getinfo($conn1);

        if ($info1['http_code'] === 200) {
            $my_token = json_decode($result1, TRUE);
            $access_token = $my_token['access_token'];
            $expires_in = $my_token['expires_in'];
            curl_close($conn1);
        } else {
            //show information regarding the error
            $errorMessage = "Error: LinkedIn server response code: " . $info1['http_code'] . " - ";
            $errorMessage .= curl_error($conn1);
            error_log($result1);
            curl_close($conn1);
            http_response_code(500);
            die($errorMessage);
        }

        // Call to API
        $conn2 = curl_init();
        curl_setopt($conn2, CURLOPT_URL, "https://api.linkedin.com/v2/me");
        curl_setopt($conn2, CURLOPT_HTTPHEADER, array(
            'Authorization: Bearer ' . $access_token
        ));

        curl_setopt($conn2, CURLOPT_RETURNTRANSFER, true);
        $result = curl_exec($conn2);
        $info2 = curl_getinfo($conn2);

        if ($info2['http_code'] === 200) {
            $data = json_decode($result, TRUE);

            curl_close($conn2);

            if (isset($data['errorCode'])) {
                $errorMessage = $data['message'];
                die($errorMessage);
            }

            $typedId = $data['id'];

            // Recall to API for email
            $conn2 = curl_init();
            curl_setopt($conn2, CURLOPT_URL, "https://api.linkedin.com/v2/emailAddress?q=members&projection=(elements*(handle~))");
            curl_setopt($conn2, CURLOPT_HTTPHEADER, array(
                'Authorization: Bearer ' . $access_token
            ));

            curl_setopt($conn2, CURLOPT_RETURNTRANSFER, true);
            $result = curl_exec($conn2);
            $info2 = curl_getinfo($conn2);

            if ($info2['http_code'] === 200) {
                $data2 = json_decode($result, TRUE);

                curl_close($conn2);

                if (isset($data['errorCode'])) {
                    $errorMessage = $data['message'];
                    die($errorMessage);
                }
            } else {
                //show information regarding the error
                $errorMessage = "Error: LinkedIn server response code: " . $info2['http_code'] . " - ";
                $errorMessage = $errorMessage . curl_error($conn2);
                curl_close($conn2);
                die($errorMessage);
            }

            $identity = new Identity(Identity::LINKEDIN);
            $identity->typedId = $typedId;
            $identity->email = $data2['elements'][0]['handle~']['emailAddress'];
            $identity->name = $data['localizedFirstName'];
            $identity->surname = $data['localizedLastName'];

            return $this->onIdentityDataReceived($identity);
        } else {
            //show information regarding the error
            $errorMessage = "Error: LinkedIn server response code: " . $info2['http_code'] . " - ";
            $errorMessage = $errorMessage . curl_error($conn2);
            error_log($result);
            curl_close($conn2);
            die($errorMessage);
        }

        return null;
    }

}
