<?php

/*
 * This file is part of rap
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

/**
 * Initialization file called by all the other pages.
 */
define('ROOT', dirname(dirname(__FILE__)));

// Defining autoload for RAP classes
spl_autoload_register(function ($class) {
    $prefix = "RAP\\";
    $len = strlen($prefix);

    if (strncmp($prefix, $class, $len) === 0) {

        $fileName = substr($class, $len, strlen($class) - $len);

        $classDirectories = ['/', '/login/', '/exceptions/', '/datalayer/', '/model/'];
        foreach ($classDirectories as $directory) {
            $classpath = ROOT . '/classes' . $directory . $fileName . '.php';
            if (file_exists($classpath)) {
                require_once $classpath;
            }
        }
    }
});

// Loading dependecy classes
include ROOT . '/vendor/autoload.php';

// Loading configuration
$config = yaml_parse_file(ROOT . '/config.yaml');
// Transforming array to object:
$config = json_decode(json_encode($config), FALSE);

// Generating locator (global registry)
$locator = new \RAP\Locator($config);
