<?php

/*
 * This file is part of rap
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

namespace RAP;

class RefreshTokenData {

    private const TOKEN_LIFESPAN = 2 * 3600;

    public function __construct() {
        $this->creationTime = time();
        $this->expirationTime = $this->creationTime + RefreshTokenData::TOKEN_LIFESPAN;
    }

    public $tokenHash;
    public $userId;
    public $creationTime;
    public $expirationTime;
    public $clientId;
    public $scope;

    public function isExpired(): bool {
        return $this->expirationTime < time();
    }

}
