<?php
include 'include/header.php';
?>
<script src="js/index.js?v=<?php echo $version; ?>"></script>

<div class="row">
    <div class="col-xs-12">
        <h1 class="text-center page-title">
            <?php
            if ($model->clientIcon != null) {
                ?>
                <img class="service-logo" src="<?php echo $model->clientIcon; ?>" alt="" />
                <?php
            }
            echo $model->clientTitle;
            ?>
        </h1>
    </div>
</div>
<div class="row" id="auth-panel">
    <div class="col-xs-12 text-center">
        <?php if ($model->eduGAIN || $model->orcid) { ?>
            <div class="home-box">
                <div class="img-wrapper">
                    <?php if ($model->eduGAIN) { ?>
                        <a href="auth/eduGAIN">
                            <img src="img/edugain-100.png" alt="eduGAIN Logo" />
                        </a>
                    <?php } ?>
                    <?php if ($model->orcid) { ?>
                        <a href="auth/orcid">
                            <img src="img/orcid-100.png" alt="ORCID Logo" />
                        </a>
                    <?php } ?>
                </div>
                Use the eduGAIN or OrcID Logo to Login or Register to RAP facility with your Institutional account. 
            </div>
        <?php } ?>
        <?php if ($model->google || $model->facebook || $model->linkedIn) { ?>
            <div class="home-box">
                <div class="img-wrapper">
                    <?php if ($model->google) { ?>
                        <a href="auth/social/google" class="animated pulse">
                            <img src="img/google-60.png" alt="Google Logo" />
                        </a>
                    <?php } ?>
                    <?php if ($model->facebook) { ?>
                        <a href="auth/social/facebook">
                            <img src="img/facebook-60.png" alt="Facebook Logo" />
                        </a>
                    <?php } ?>
                    <?php if ($model->linkedIn) { ?>
                        <a href="auth/social/linkedin">
                            <img src="img/linkedin-60.png" alt="LinkedIn Logo" />
                        </a>
                    <?php } ?>
                </div>
                Use these Logos to Login or Register to the RAP facility with your social identity
            </div>
        <?php } ?>
        <?php if ($model->x509) { ?>
            <div class="home-box">
                <div class="img-wrapper">
                    <a href="auth/x509">
                        <img src="img/x509-200.png" alt="X.509 Logo" />
                    </a>
                </div>
                Use the X.509 Logo to Login with your personal certificate (IGTF and TERENA-TACAR, are allowed).
            </div>
        <?php } ?>
        <?php if ($model->localIdP) { ?>
            <div class="home-box">
                <div class="img-wrapper">
                    <a href="local">
                        <img src="<?php echo $model->localIdPConfig->logo; ?>" alt="<?php echo $model->localIdPConfig->logoAlt; ?>" />
                    </a>
                </div>
                <?php echo $model->localIdPConfig->description; ?>
            </div>
        <?php } ?>
        <?php if ($model->test) { ?>
            <div class="home-box">
                <div class="img-wrapper">
                    <a href="auth/test">
                        <strong>Test Login</strong>
                    </a>
                </div>
                Use fake accounts
            </div>
        <?php } ?>
    </div>
</div>

<script>
    $(document).on('click', '#auth-panel a', showWaiting);
</script>

<?php
include 'include/footer.php';

