<?php

use PHPUnit\Framework\TestCase;

class ClientAuthCheckerTest extends TestCase {

    public function testValidateClientAuth() {

        $locatorStub = $this->createMock(\RAP\Locator::class);

        $locatorStub->expects($this->once())
                ->method('getBrowserBasedOAuth2ClientByIdAndSecret')->with('client', 'secret');

        $authChecker = new \RAP\ClientAuthChecker($locatorStub);
        $authChecker->validateClientAuth([
            "Authorization" => "Basic " . base64_encode("client:secret")
        ]);
    }

    public function testValidateCliClientAuth() {

        $locatorStub = $this->createMock(\RAP\Locator::class);

        $locatorStub->expects($this->once())
                ->method('getCliClientByIdAndSecret')->with('client', 'secret');

        $authChecker = new \RAP\ClientAuthChecker($locatorStub);
        $authChecker->validateCliClientAuth([
            "Authorization" => "Basic " . base64_encode("client:secret")
        ]);
    }

}
