<?php

class MySQLUserDAOTest extends BaseDAOTest {

    public function setUp(): void {
        $this->dao = new \RAP\MySQLUserDAO($this->getFakeLocator());
    }

    public function testJoinUsersAfterKeepSeparated() {

        $user1 = $this->createUser(\RAP\Identity::EDU_GAIN, 'name.surname@inaf.it', '001');
        $user2 = $this->createUser(\RAP\Identity::GOOGLE, 'name.surname@inaf.it', '002');
        $user3 = $this->createUser(\RAP\Identity::LINKEDIN, 'test@inaf.it', '003');

        $joinable1 = $this->dao->findJoinableUsersByUserId($user1->id);
        $this->assertEquals(1, count($joinable1));
        $this->assertEquals($user2->id, $joinable1[0]);

        $joinable2 = $this->dao->findJoinableUsersByUserId($user2->id);
        $this->assertEquals(1, count($joinable2));
        $this->assertEquals($user1->id, $joinable2[0]);

        // Add records to keep_separated table to test the two DELETE statements before the join
        $this->dao->insertRejectedJoin($user1->id, $user2->id);
        $this->dao->insertRejectedJoin($user2->id, $user3->id);

        $joinable = $this->dao->findJoinableUsersByUserId($user1->id);
        $this->assertEquals(0, count($joinable));

        $this->dao->joinUsers($user1->id, $user2->id);

        $joinedUser = $this->dao->findUserById($user1->id);
        $this->assertEquals(2, count($joinedUser->identities));

        $this->assertNull($this->dao->findUserById($user2->id));
    }

    private function createUser(string $identityType, string $email, string $typedId) {
        $user = new \RAP\User();
        $user->id = $this->dao->createUser();

        $identity = new \RAP\Identity($identityType);
        $identity->email = $email;
        $identity->typedId = $typedId;

        $this->dao->insertIdentity($identity, $user->id);

        $savedUser = $this->dao->findUserById($user->id);

        $this->assertEquals($user->id, $savedUser->id);

        return $savedUser;
    }

}
