<?php

/* ----------------------------------------------------------------------------
 *               INAF - National Institute for Astrophysics
 *               IRA  - Radioastronomical Institute - Bologna
 *               OATS - Astronomical Observatory - Trieste
 * ----------------------------------------------------------------------------
 *
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

include './include/init.php';

include './include/front-controller.php';
include './include/gui-backend.php';
include './include/rest-web-service.php';

Flight::set('flight.log_errors', true);

// Error handling
Flight::map('error', function($ex) {
    if ($ex instanceof \Exception) {
        error_log($ex->getTraceAsString());
    } else {
        http_response_code(500);
        throw $ex;
    }
    $message = "A fatal error happened";
    if ($ex instanceof \RAP\BadRequestException) {
        http_response_code(400);
        $message = "Bad request: " . $ex->message;
    } else if ($ex instanceof \RAP\UnauthorizedException) {
        http_response_code(401);
        $message = "Unauthorized: " . $ex->message;
    } else if ($ex instanceof \Exception) {
        http_response_code(500);
        if ($ex->getMessage() !== null) {
            $message = $ex->getMessage();
        }
    }

    $headers = apache_request_headers();
    $useJson = false;
    if (array_key_exists('Accept', $headers)) {
        $accept = $headers['Accept'];
        $useJson = ($accept === 'application/json' || $accept === 'text/json');
    }

    if ($useJson) {
        echo json_encode(["error" => $message]);
    } else {
        global $locator;
        Flight::render('error.php', array('title' => 'Error',
            'version' => $locator->getVersion(), 'error' => $message,
            'contactEmail' => isset($locator->config->contactEmail) ? $locator->config->contactEmail : null,
            'contactLabel' => isset($locator->config->contactLabel) ? $locator->config->contactLabel : null,
            'contextRoot' => $locator->config->contextRoot));
    }
});

// Starting Flight framework
Flight::start();
