<?php

/**
 * REST Web Service using http://flightphp.com/
 */
//
$WS_PREFIX = '/ws';

/**
 * Retrieve user information from user ID.
 */
Flight::route('GET ' . $WS_PREFIX . '/user/@userId', function($userId) {

    global $locator;

    $token = $locator->getTokenChecker()->validateToken();
    $locator->getTokenChecker()->checkScope($token, 'read:rap');

    $user = $locator->getUserDAO()->findUserById($userId);
    if ($user !== null) {
        Flight::json($user);
    } else {
        http_response_code(404);
        die("User not found");
    }
});

/**
 * Search users from search text (name, surname, email).
 */
Flight::route('GET ' . $WS_PREFIX . '/user', function() {

    global $locator;

    $token = $locator->getTokenChecker()->validateToken();
    $locator->getTokenChecker()->checkScope($token, 'read:rap');

    $searchText = Flight::request()->query['search'];
    if ($searchText !== null) {
        $users = $locator->getUserDAO()->searchUser($searchText);
    } else {
        $identifiers = Flight::request()->query['identifiers'];
        if ($identifiers === null) {
            throw new \RAP\BadRequestException("Missing identifiers parameters");
        }
        $identifiers = explode(',', $identifiers);
        $users = $locator->getUserDAO()->getUsers($identifiers);
    }

    Flight::json($users);
});

/**
 * Create new user from identity data. Return the new user encoded in JSON.
 * This can be used to automatically import users without they explicitly
 * register (this is done for INAF eduGAIN users reading directly from LDAP).
 */
Flight::route('POST ' . $WS_PREFIX . '/user', function() {

    global $locator;

    $token = $locator->getTokenChecker()->validateToken();
    $locator->getTokenChecker()->checkScope($token, 'write:rap');

    $postData = Flight::request()->data;

    $user = new RAP\User();

    $identity = new RAP\Identity($postData['type']);

    $identity->email = $postData['email'];
    $identity->typedId = $postData['typedId'];
    if (isset($postData['name'])) {
        $identity->name = $postData['name'];
    }
    if (isset($postData['surname'])) {
        $identity->surname = $postData['surname'];
    }
    if (isset($postData['institution'])) {
        $identity->institution = $postData['institution'];
    }
    if (isset($postData['eppn'])) {
        $identity->eppn = $postData['eppn'];
    }

    $user->addIdentity($identity);

    $locator->getUserHandler()->saveUser($user);

    Flight::json($user);
});

Flight::route('POST ' . $WS_PREFIX . '/exchange', function() {

    global $locator;

    $subjectToken = Flight::request()->data['subject_token'];

    $exchanger = new \RAP\TokenExchanger($locator);

    Flight::json($exchanger->exchangeTokenOld($subjectToken));
});
