<?php

namespace RAP;

use PDO;

abstract class BaseMySQLDAO {

    private $locator;

    public function __construct(Locator $locator) {
        $this->locator = $locator;
    }

    /**
     * @return type PDO object for accessing the database
     */
    public function getDBHandler(): PDO {
        $config = $this->locator->config->databaseConfig;
        $connectionString = "mysql:host=" . $config->hostname . ";port=" . $config->port . ";dbname=" . $config->dbname;
        $dbh = new PDO($connectionString, $config->username, $config->password);
        // For transaction errors (see https://stackoverflow.com/a/9659366/771431)
        $dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        return $dbh;
    }

}
