<?php

use PHPUnit\Framework\TestCase;

final class JWKSHandlerTest extends TestCase {

    public function testKeyPairCreation(): void {

        $daoStub = $this->createMock(\RAP\JWKSDAO::class);

        $locatorStub = $this->createMock(\RAP\Locator::class);
        $locatorStub->method('getJWKSDAO')->willReturn($daoStub);

        $JWKSHandler = new \RAP\JWKSHandler($locatorStub);

        $daoStub->expects($this->once())
                ->method('insertRSAKeyPair')->with($this->anything());

        $result = $JWKSHandler->generateKeyPair();

        $this->assertNotNull($result->keyId);
        $this->assertNotNull($result->privateKey);
        $this->assertNotNull($result->publicKey);
    }

}
