<?php

namespace RAP;

trait ClientsLocator {

    public function getBrowserBasedOAuth2Clients(): array {
        return array_map(function($clientConfig) {
            return new BrowserBasedOAuth2Client($clientConfig);
        }, $this->config->clients);
    }

    public function getBrowserBasedOAuth2ClientById(string $clientId, bool $allowNull = false): ?BrowserBasedOAuth2Client {
        $clientConfig = $this->getClientConfigFromListById($this->config->clients, $clientId, $allowNull);
        if ($allowNull && $clientConfig === null) {
            return null;
        }
        return new BrowserBasedOAuth2Client($clientConfig);
    }

    public function getBrowserBasedOAuth2ClientByIdAndSecret(string $clientId, string $secret): BrowserBasedOAuth2Client {
        $clientConfig = $this->getClientConfigFromListByIdAndSecret($this->config->clients, $clientId, $secret);
        return new BrowserBasedOAuth2Client($clientConfig);
    }

    public function getCliClientByIdAndSecret(string $clientId, string $secret): CliOAuth2Client {
        $clientConfig = $this->getClientConfigFromListByIdAndSecret($this->config->cliClients, $clientId, $secret);
        return new CliOAuth2Client($clientConfig);
    }

    private function getClientConfigFromListByIdAndSecret(array $clients, string $clientId, string $secret): object {
        $client = $this->getClientConfigFromListById($clients, $clientId);
        $secretHash = hash('sha256', $secret);
        if ($client->secret !== $secretHash) {
            throw new UnauthorizedException("Wrong secret provided for client '$clientId'");
        }
        return $client;
    }

    private function getClientConfigFromListById(array $clients, string $clientId, bool $allowNull = false): ?object {
        $client = null;
        foreach ($clients as $c) {
            if ($c->id === $clientId) {
                if ($client !== null) {
                    throw new ServerErrorException("Found multiple clients having id '$clientId'");
                }
                $client = $c;
            }
        }
        if ($client === null && !$allowNull) {
            throw new BadRequestException("Client '$clientId' not configured");
        }
        return $client;
    }

}
