<?php

/* ----------------------------------------------------------------------------
 *               INAF - National Institute for Astrophysics
 *               IRA  - Radioastronomical Institute - Bologna
 *               OATS - Astronomical Observatory - Trieste
 * ----------------------------------------------------------------------------
 *
 * Copyright (C) 2019 Istituto Nazionale di Astrofisica
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

namespace RAP;

/**
 * Data model for storing information about a RAP client connecting using OAuth2.
 */
class BrowserBasedOAuth2Client extends BrowserBasedClient {

    public $client;
    public $secretHash;
    public $redirectUrl;
    public $scope;
    public $homePage;
    public $showInHome;
    public $jwks;
    public $scopeAudienceMap = [];

    public function __construct(object $config) {
        $this->client = $config->id;
        $this->secretHash = $config->secret;
        $this->title = isset($config->label) ? $config->label : null;
        $this->icon = isset($config->icon) ? $config->icon : null;
        $this->redirectUrl = $config->redirect;
        $this->scope = $config->scope;
        $this->homePage = isset($config->home) ? $config->home : null;
        $this->showInHome = isset($config->showInHome) ? $config->showInHome : false;
        $this->authMethods = $config->methods;
        $this->jwks = isset($config->jwks) ? $config->jwks : null;
        $this->scopeAudienceMap = isset($config->scopeAudienceMap) ? $config->scopeAudienceMap : null;
    }

    public function getIconBasePath() {
        return 'client-icons/';
    }

}
