<?php

namespace RAP;

class ShibbolethLogin extends LoginHandler {

    public function __construct(Locator $locator) {
        parent::__construct($locator, Identity::EDU_GAIN);
    }

    public function login() {

        if (isset($_SERVER['Shib-Session-ID'])) {

            // Retrieving eduPersonPrincipalName (eppn)
            $eppn = $_SERVER['eppn'];

            // Search if the user is already registered into RAP using the eppn.
            // The persistent id should be a more appropriate identifier, however at IA2
            // we need to import all INAF user into RAP, even if they will never register,
            // and in that case we know only their eppn.

            return $this->onIdentityDataReceived($eppn, function($identity) use($eppn) {
                        $identity->email = $_SERVER['mail'];
                        if (isset($_SERVER['givenName']) && $_SERVER['givenName'] !== 'N/A') {
                            $identity->name = $_SERVER['givenName'];
                        }
                        if (isset($_SERVER['sn']) && $_SERVER['sn'] !== 'N/A') {
                            $identity->surname = $_SERVER['sn'];
                        }
                        $identity->eppn = $eppn;
                    });
        } else {
            throw new ServerErrorException("Shib-Session-ID not found!");
        }
    }

}
